(function() {
    "use strict";

    var Keyset = {};
    var App = window.App;
    var Player = window.Player;
    var $ = window.$;

    var Keys = {
        number: '',
        time: false,
        timer: null,

        gotoCh: function() {
            Keys.time = false;
            $('#chanel-number').hide();
            // переход на канал
            App.scenes.iptv.numChanel(Keys.number);
            console.log(Keys.number);
            Keys.number = '';
        },

        preCh: function(num)
        {
            if (Keys.number.length >= 2) {
                Keys.number = num;
            } else {
                Keys.number = Keys.number + num;
            }
            $('#chanel-number').text(Keys.number);
        },

        // reset: function()
        // {
        //     $(document.body).off('nav_key:pause');
        //     $(document.body).off('nav_key:exit');
        //     $(document.body).off('nav_key:return');
        //     $(document.body).off('nav_key:info');
        //     $(document.body).off('nav_key:enter');
        //     App.scenes.iptv.$el.off('nav_key:enter');
        //     $(document.body).off('nav_key:ch_up');
        //     $(document.body).off('nav_key:ch_down');
        //     // $(document.body).off('nav_key:up');
        //     // $(document.body).off('nav_key:down');
        //     // $(document.body).off('nav_key:left');
        //     // $(document.body).off('nav_key:right');
        //     $(document.body).off('nav_key:num');
        //     $(document.body).off('nav_key:back');
        // },
        set: function(view) {
            // this.reset();

            // reset
            if (this.view && Keyset[this.view]) {
              $(document.body).off(Keyset[this.view]);
            }

            $(document.body).on(Keyset[view]);

            this.view = view;
        }
    }

  // Программа
	Keyset.program = {
      'nav_key:info': function() {
        App.scenes.program.returnToBack();
      },
      'nav_key:return': function() {
        App.scenes.program.returnToBack();
      },
      'nav_key:back': function() {
        App.scenes.program.returnToBack();
      },
      'nav_key:down': function(e) {
        App.scenes.program.openNextProgram(e);
      },
      'nav_key:up': function(e) {
        App.scenes.program.openPrevProgram(e);
      },
      'nav_key:enter': function(e) {
        App.scenes.program.openChannel(e);
      }
	}

	// Настройки
	 Keyset.settings = {
      'nav_key:back': function() {
        App.scenes.settings.backFromInterface();
      }
	}

    // Во время просмотра канала всплывающий интерфейс
    Keyset.iptv_interface = {
      'nav_key:back': function() {
        App.modules.interfaceOverTv.hide();
      },
      'nav_key:return': function() {
        App.modules.interfaceOverTv.hide();
      },
      'nav_key:down': function() {
        App.modules.interfaceOverTv.updateTimer();
      },
      'nav_key:up': function() {
        App.modules.interfaceOverTv.updateTimer();
      },
      'nav_key:left': function() {
        App.modules.interfaceOverTv.updateTimer();
      },
      'nav_key:right': function() {
        App.modules.interfaceOverTv.updateTimer();
      },
      'nav_key:enter': function() {
        App.scenes.iptv.onEnterClick.apply(this, arguments);
        App.modules.interfaceOverTv.updateTimer();
      },
      'nav_key:info': function() {
        App.openScene('program');
      }
    };

    // Выбор канала
    Keyset.iptv = {
      'nav_key:pause': function() {
        Player.togglePause();
      },
      'nav_key:exit': function() {
        App.confirmAndExitOrCloseConfirm();
      },
      'nav_key:return': function() {
        App.confirmAndExitOrCloseConfirm();
      },
      'nav_key:back': function() {
        App.confirmAndExitOrCloseConfirm();
      },
      'nav_key:enter': function() {
        App.scenes.iptv.onEnterClick.apply(this, arguments);
      },
      'nav_key:info': function() {
        App.scenes.program.from = 'iptv';
        App.openScene('program');
      }
    };

    // Просмотр канала
    Keyset.iptv_view = {
      'nav_key:back': function() {
        App.scenes.iptv.exitPlayVideoView();
      },
      'nav_key:return': function() {
        App.scenes.iptv.exitPlayVideoView();
      },
      'nav_key:info': function() {
        App.scenes.program.from = 'iptv_view';
        App.openScene('program');
      },
      'nav_key:ch_up': function() {
        App.scenes.iptv.previosChannel();
      },
      'nav_key:ch_down': function() {
        App.scenes.iptv.nextChannel();
      },
      'nav_key:num': function(e) {
        if (Keys.time) {
          console.log('запущен, пишем в буфер');
          Keys.preCh(e.num);
        } else {
          Keys.preCh(e.num);
          Keys.time = true;
          console.log('старт таймера');
          $('#chanel-number').show();
          Keys.timer = setTimeout(Keys.gotoCh, 2000);
        }
      },
      'nav_key:down': function() {
        App.modules.interfaceOverTv.show();
      },
      'nav_key:up': function() {
        App.modules.interfaceOverTv.show();
      },
      'nav_key:left': function() {
        App.modules.interfaceOverTv.show();
      },
      'nav_key:right': function() {
        App.modules.interfaceOverTv.show();
      },
      'nav_key:enter': function() {
        App.modules.interfaceOverTv.show();
      },
    };

    // Сцены базируются с возможностью воспроизвести видео
    Keyset.videoController = {
        'nav_key:back': function() {
          App.currentScene.back();
        },
        'nav_key:return': function() {
          App.currentScene.back();
        },
        'nav_key:exit': function() {
          App.confirmAndExitOrCloseConfirm();
        },
        'nav_key:info': function() {
          App.modules.videoController.toggleDetails();
        }
    };

    Keyset.playerController = {
      'nav_key:back': function() {
        return (
          App.modules.playerController.hidePlayerInterface() ||
          App.currentScene.back()
        )
      },
      'nav_key:return': function() {
        return (
          App.modules.playerController.hidePlayerInterface() ||
          App.currentScene.back()
        )
      },
      'nav_key:exit': function() {
        App.confirmAndExitOrCloseConfirm();
      },
      'nav_key:pause': function() {
        Player.togglePause();
      },
      'nav_key:forward': function() {
        App.modules.playerController.forward();
      },
      'nav_key:backward': function() {
        App.modules.playerController.backward();
      },
      'nav_key:next': function() {
        App.modules.playerController.fastForward();
      },
      'nav_key:previous': function() {
        App.modules.playerController.fastBackward();
      },
      'nav_key:enter': function() {
        App.modules.playerController.showPlayerInterface();
      },
      'nav_key:down': function() {
        App.modules.playerController.showPlayerInterface();
      },
      'nav_key:up': function() {
        App.modules.playerController.showPlayerInterface();
      },
      'nav_key:left': function() {
        App.modules.playerController.showPlayerInterface();
      },
      'nav_key:right': function() {
        App.modules.playerController.showPlayerInterface();
      }
    };

    window.Keys = Keys;

})();
