$(function () {
  "use strict";

  var App = window.App;

  var $body = $(document.body),
    keys = window.$$legend.keys;

  $('.menu-item').on({
    'nav_focus': function () {
      App.dispatch(App.legendActions.setEnter('show'));
    },
    'nav_blur': function () {
      App.dispatch(App.legendActions.setEnter(''));
    }
  });

  $body.on('nav_focus', '.input-item', function() {
    App.dispatch(App.legendActions.setEnter('keyboard'));
    App.dispatch(App.legendActions.setNumber('numbers'));
  });

  $body.on('nav_blur', '.input-item', function() {
    App.dispatch(App.legendActions.setEnter(''));
    App.dispatch(App.legendActions.setNumber(''));
  });

  $body.on('nav_focus', '#keyboard_popup', function () {
    App.dispatch(App.legendActions.setEnter('enter'));
    App.dispatch(App.legendActions.setNumber('numbers'));
    App.dispatch(App.legendActions.setRed('delete_char'));
    App.dispatch(App.legendActions.setGreen('ready'));
    App.dispatch(App.legendActions.setRet('hide_keyboard'));
  });

  $body.on('nav_blur', '#keyboard_popup', function () {
    App.dispatch(App.legendActions.setEnter(''));
    App.dispatch(App.legendActions.setNumber(''));
    App.dispatch(App.legendActions.setRed(''));
    App.dispatch(App.legendActions.setGreen(''));
    App.dispatch(App.legendActions.setRet(''));
  });

  $body.on('nav_focus', '.navigation-item', function() {
    App.dispatch(App.legendActions.setMove('navigation'));
  });

  $body.on('nav_blur', '.navigation-item', function() {
    keys.move('');
  });

  $body.on('nav_focus', '.video-item', function () {
    App.dispatch(App.legendActions.setEnter('play'));
  });

  $body.on('nav_blur', '.video-item', function () {
    App.dispatch(App.legendActions.setEnter(''));
  });
});
