/* global App, APP_CONFIG, Player */
/* global $ */

var AppAdvertisements = {};

(function() {
  $.extend(AppAdvertisements, {
    firstAfterMinutes: 10,
    nextAfterMinutes: 15,

    STATUSES: {
      WAITING: 0,
      UPDATING: 1,
      SHOWING: 2,
    },

    showTimerID: null,
    showFirstTimerID: null,

    init: function (serverConfig) {
      if (!serverConfig.advertisements_enabled) {
        return;
      }

      this.firstAfterMinutes = serverConfig.advertisements_first_after_minutes;
      this.nextAfterMinutes =  serverConfig.advertisements_next_after_minutes;

      App.dispatch(App.advActions.setOpacity(serverConfig.advertisements_opacity));
      App.dispatch(App.advActions.setMaxSizePercent(serverConfig.advertisements_max_size_percent));
      App.dispatch(App.advActions.setShowSeconds(serverConfig.advertisements_show_seconds));
      App.dispatch(App.advActions.setPosition(serverConfig.advertisements_position));

      Player.on("bufferingEnd", function () { AppAdvertisements.onBufferingEnd() });
      Player.on("stop", function () { AppAdvertisements.onVideoStop() });
    },

    showNext: function () {
      App.dispatch(App.advActions.showNext());

      this.showNextTimerID = setTimeout(function () {
        AppAdvertisements.showNext();
      }, this.nextAfterMinutes * 60 * 1000);
    },

    onBufferingEnd: function () {
      if (!this.isVideoPlaying) {
        this.onVideoStart();
      }
    },

    onVideoStart: function () {
      updateAdvList();

      this.showFirstTimerID = setTimeout(function () {
        AppAdvertisements.showNext();
      }, this.firstAfterMinutes * 60 * 1000);

      this.isVideoPlaying = true;
    },

    onVideoStop: function () {
      clearTimeout(this.showFirstTimerID);
      clearTimeout(this.showNextTimerID);

      this.isVideoPlaying = false;
    }
  });

  function updateAdvList() {
    requestAdvList(function () {
      var advList = AppAdvertisements.advList;

      if (!advList.length) {
        return;
      }

      if (checkAdvListChanged(advList)) {
        shuffleArray(advList);
        setAdvList(advList);
      }
    });
  }

  function requestAdvList(callback) {
    var script = document.createElement('script');
    var scriptSrc = App.getApiUrl(APP_CONFIG.ADV_LIST_URL + '?' + Date.now());

    script.src = scriptSrc;
    script.onload = function () {
      callback();
    }

    document.body.appendChild(script);
  }

  function shuffleArray(array) {
    var currentIndex = array.length - 1;
    var randomIndex;
    var randomValue;

    while (currentIndex !== 0) {

      randomIndex = Math.floor(Math.random() * currentIndex);
      randomValue = array[randomIndex];

      array[randomIndex] = array[currentIndex];
      array[currentIndex] = randomValue;

      currentIndex--;
    }

    return array;
  }

  function checkAdvListChanged(advList) {
    var prevList = (App.getState().adv.list || []).slice().sort();
    var updatedList = advList.slice().sort();

    return prevList.toString() !== updatedList.toString();
  }

  function setAdvList(advList) {
    App.dispatch(App.advActions.setList(advList));
  }

})()
