/* global App, Keys, APP_CONFIG */
/* global $, $$nav, $$log */

(function() {
  "use strict";

  App.modules.interfaceOverTv = {
    visible: false,

    // Плавный показ интерфейса поверх видео
    show: function () {
      if (this.visible) {
        return;
      }

      $$nav.current(App.scenes.iptv.getCurrentChannelItem());

      App.scenes.iptv.show('iptv_interface');

      this.updateTimer();

      this.visible = true;

      $('#version').show();
      $('#channelPreview').stop().animate({ opacity: 1 });
    },

    hide: function () {
      // Анимация
      $('.menu').stop().animate({
        left: -200,
        opacity: 0
      }, function () {
        $('.menu').hide()
      });

      // Сет клавиш просмотра канала
      Keys.set('iptv_view');

      this.stopTimer();

      this.visible = false;

      $('#version').hide();
      $('#channelPreview').css({ opacity: 0 });
    },

  	updateTimer: function () {
      clearTimeout(this.timer);

      this.timer = setTimeout(function() {
        App.modules.interfaceOverTv.hide();
      }, APP_CONFIG.IPTV_HIDE_INTERFACE_TIMER_MS);
    },

  	stopTimer: function () {
  	  clearTimeout(this.timer);
      this.timer = null;
  	}

  };

})();
