(function() {
    "use strict";

    var $ = window.$;
    var $$log = window.$$log;
    var App = window.App;
    var Player = window.Player;

    $.extend(App.modules.player, {

      init: function () {
        // tizen: Плеер выполнил prepare и начал буферизацию
        Player.on('ready', function() {
          App.$bg.hide();

          $$log('player ready');

          App.playerPause = false;
          App.playerState = 0;

          if (App.currentScene.toString() === 'onevideo')
          {
              var duration = Player.videoInfo.duration;
              var seekTime = 10;
              if (duration > 5400)
              {
                  seekTime = 180;
              }
              else
              {
                  if (duration > 600)
                  {
                      seekTime = 120;
                  }
                  else
                  {
                      seekTime = 10;
                  }
              }

              App.progressBar(true);

              App.playBarTimer = setTimeout(function() {
                  App.progressBar(false);
                  clearTimeout(App.playBarTimer);
              }, 5000);

              $('#duration').html(Player.formatTime(duration));

              App.playTimer = setInterval(function() {
                  $('#duration').html(Player.formatTime(duration));
                  $('#duration-cur').html(Player.formatTime(Player.videoInfo.currentTime));
                  var currentPosition = (Player.videoInfo.currentTime * 100) / duration;
                  App.progressBar(currentPosition);
              }, 1000);

              App.scenes.videoLibrary.$el.off('nav_key:enter', '.video-item');

              App.scenes.videoLibrary.$el.on('nav_key:enter', '.video-item', function() {
                  // настраиваем автоскрытие прогресс бара
                  App.progressBar(true);
                  App.playBarTimer = setTimeout(function() {
                      App.progressBar(false);
                      clearTimeout(App.playBarTimer);
                  }, 5000);
              });

              $(document.body).on({
                'nav_key:rew': function() {
                  // настраиваем автоскрытие прогресс бара
                    App.progressBar(true);
                    App.playBarTimer = setTimeout(function() {
                        App.progressBar(false);
                        clearTimeout(App.playBarTimer);
                    }, 5000);
                    // перематываем назад
                    Player.seek(Player.videoInfo.currentTime - seekTime);
                },

                'nav_key:ff': function() {
                  // настраиваем автоскрытие прогресс бара
                  App.progressBar(true);
                  App.playBarTimer = setTimeout(function() {
                      App.progressBar(false);
                      clearTimeout(App.playBarTimer);
                  }, 5000);
                  // перематываем вперед
                  Player.seek(Player.videoInfo.currentTime + seekTime);
                },

                'nav_key:pause': function() {
                  $$log('нажали кнопку - пауза');
                  if (Player.state === 'play')
                  {
                      Player.pause();
                      App.progressBar(true);
                  }
                  else if (Player.state === 'pause')
                  {
                      Player.resume();
                      App.progressBar(false);
                  }

                  $$log(Player.state);
                },

                'nav_key:stop': function() {
                  App.stopVideo();
                },

                'nav_key:return': function() {
                  App.stopVideo();
                }
              });
          }
        });

        Player.on('stop', function() {
          $$log('player stop');

          App.runText(false);
          App.loader(false);
          App.$bg.show();
        });

        Player.on('complete', function() {
          $$log('complete');
          if (App.currentScene.toString()  === 'videoLibrary')
          {
              App.loader(true);
              Player.play({
                  url: App.playerLast,
                  type: 'vod'
              });
          }
          $$log('complete end');
        });

        Player.on('prepare', function() {
          self.loaderProc('');
          self.loader(true);
        });

        Player.on('bufferingBegin', function() {
          self.loaderProc(0);
          self.loader(true);
        });

        Player.on('bufferingEnd', function() {

          // Включаем бегущую строку
          App.runText( true );

          if (App.error_buf)
          {
              App.error_buf = false;
              clearTimeout(App.errorBufTimer);
          }
          self.loaderProc(100);
          self.loader(false, 'Player::bufferingEnd');
        });

        Player.on('buffering', function(proc) {
            self.loaderProc(proc);
        });
      }

    });
})()
