/* global $, APP_CONFIG, App */

(function() {
    "use strict";

    var _isLoaded = false;
    var _isEnabled = false;

    if (APP_CONFIG.RUNTEXT_ENABLED) {
      loadRunText();
    }

    $.extend(App, {

      // Управление Бегущей строкой
      runText: function ( enable ) {

        _isEnabled = enable;

        if (!App.runTexts) {
          return;
        }

        if ( enable ) {
          // Запустить бегущую строку
          this.$runText.show();
          this._cicleRunText();
        } else {
          // Остановить бегущую строку
          this.$runText.hide();
          this.$runText.find('span').stop();
        }
      },

      // Циклическое проигрывание бегущих строк
      _cicleRunText: function () {
        var areaWidth = this.$runText.width();
        var $span = this.$runText.find('span');

        $span.html(App.runTexts[0]);

        var runWidth = $span.width();
        var time = APP_CONFIG.RUNTEXT_SPEED_MS * Math.max(runWidth / areaWidth, 1);

        return $span.css({
          left: areaWidth + 200
        }).animate({
          left: -runWidth
        }, time, "linear", function () {
          App.runTexts.push(App.runTexts[0]);
          App.runTexts.shift();
          App._cicleRunText();
        })
      }
    });

    function loadRunText() {
      if (_isLoaded) {
        return;
      }

      $(function () {
        var script = document.createElement('script');
        var scriptSrc = App.getApiUrl(APP_CONFIG.RUNTEXT_URL + '?' + (new Date()).getTime());

        script.src = scriptSrc;
        script.onload = function () {
          if (_isEnabled) {
            App.runText( true );
          }
        }

        document.body.appendChild(script);

        _isLoaded = true;
      })
    }
})()
