/* global Player, App, APP_CONFIG */
/* global $, $$nav, _ */

(function() {
    "use strict";

    App.modules.videoController = {
      episodesSelector: '#video-episodes',
      detailsSelector: '#video-details',

      isDetailsOpened: function() {
        return $(this.detailsSelector).is(':visible');
      },

      isEpisodesOpened: function() {
        return $(this.episodesSelector).is(':visible');
      },

      navToButtonsBlock: function () {
        $$nav.current(App.currentScene.$el.find('#play-button'));
      },

      renderVideoInfo: function(film) {
        App.dispatch(App.videoActions.focusFilm(film));
      },

      openVideoDetails: function(film) {
        App.dispatch(App.videoActions.setDetailsFilm(film));
      },

      closeFilmDetails: function() {
        App.dispatch(App.videoActions.setDetailsFilm(null));

        App.modules.videoController.resetFocus();
      },

      resetFocus: function () {
        $$nav.on('.wrap');
      },

      openEpisodesPopup: function(video) {
        var episodes = _.values(video.files.files);

        App.dispatch(App.videoActions.setEpisodes(episodes));

        $(this.episodesSelector).fadeIn();

        $$nav.save();
        $$nav.on($(this.episodesSelector));
      },

      closeEpisodesPopup: function(film) {
        $(this.episodesSelector).fadeOut();
        $$nav.restore();
      },

      likeFilm: function(film, callback) {
        this.api('method=like_film&id='+film.id, function (film) {
          delete film.poster;
          App.dispatch(App.videoActions.updateFilm(film));
        });
      },

      delikeFilm: function(film) {
        this.api('method=delike_film&id='+film.id, function (film) {
          delete film.poster;
          App.dispatch(App.videoActions.updateFilm(film));
        });
      },

      api: function(param, callback) {
        $.ajax({
          dataType: "json",
          url: APP_CONFIG.VIDEO_API_URL + '?' + param,
          data: {},
          success: function(data) {
              callback(data.result);
          }
        });
      },

      toggleDetails: function () {
        if (App.modules.videoController.isDetailsOpened()) {
          App.modules.videoController.closeFilmDetails();
        } else {
          App.modules.videoController.openVideoDetails();
        }
      },

      onPlayClick: function (video) {
        if (!App.modules.interface.isVisible) {
          return;
        }

        if (!video) {
          return;
        }

        var isFilmUploadedSuccess = video.files.files;

        if (!isFilmUploadedSuccess) {
          App.error('video_unavailable_error', function() {

          });
          return;
        }

        App.dispatch(App.playerActions.setTitle(video.name));

        if (video.files.type !== 'film') {
          App.modules.videoController.openEpisodesPopup(video);
          return;
        }

        App.modules.playerController.playSupportedFile(video.files.files);
      },

      restore: function () {
        if (this.isDetailsOpened()) {
          $$nav.on($(this.detailsSelector));
        } else {
          $$nav.on('.wrap');
        }
      },

      back: function () {
        if (this.isEpisodesOpened()) {
          this.closeEpisodesPopup();
        } else if (!App.modules.interface.isVisible) {
          Player.stop();
        } else if (this.isDetailsOpened()) {
          this.closeFilmDetails();
        } else {
          return false;
        }

        return true;
      }
    }
})();
