/* global $, APP_CONFIG, SB */

$(function () {
  updateApplicationScale();

  $(window).resize(function () {
    updateApplicationScale();
  })
})

function updateApplicationScale() {
  if (SB.platformName === 'samsung') {
    updateZoomScale();
    return;
  }

  updateViewportScale();
}

function updateViewportScale () {
  var screenHeight = window.screen.height;
  var k = screenHeight / APP_CONFIG.SCALING_TO_HEIGHT;

  setViewportScale(k);
}

function updateZoomScale() {
  $(document.body).css({
    // transform: 'inherit',
    zoom: 'inherit',
    height: 'inherit',
    width: 'inherit',
  });

  var screenHeight = $(document.body).height();
  var k = screenHeight / APP_CONFIG.SCALING_TO_HEIGHT;

  setZoomScale(k);
}

function setZoomScale(scale) {
  var screenWidth = $(document.body).width();

  $(document.body).css({
    zoom: scale,
    // transform: 'scale('+zoom+')',
    // transformOrigin: 'left top',
    height: APP_CONFIG.SCALING_TO_HEIGHT,
    width: screenWidth / scale
  })
}

function setViewportScale(scale) {
  var $viewport = $('meta[name="viewport"]');
  var content = $viewport.attr('content');

  scale = scale.toString().replace(',','.');
  content = content.replace(/(.*?)initial-scale=(.*)?/gi, "$1initial-scale=" + scale)
  $viewport.attr('content', content);
}
