(function() {
    "use strict";
    var _inited;

    var App = window.App;
    var $ = window.jQuery;
    var $$legend = window.$$legend;
    var Keys = window.Keys;

    App.scenes.bookmarks = {
      toString: function() {
          return 'bookmarks';
      },
      bodyClassName: 'scene-bookmarks scene-videos',
      films: [],
      init: function() {
        _inited = true;

        this.$el = $('.scene-bookmarks-content');
        this.$videosList = this.$el.find('.videos-list');

        App.scenes.bookmarks.$el.on('nav_key:enter', '.video-item', function (e) {
          App.modules.videoController.navToButtonsBlock()
        });
      },

      show: function() {
          if (!_inited) {
              this.init();
          }

          App.dispatch(App.videoActions.focusFilm(null));

          this.$el.show();
  			  $('li[data-scene=bookmarks]').addClass('active');

          $$legend.hide();
          Keys.set('videoController');

          this.focusFirst();
      },

      hide: function() {
          this.$el.hide();
		      $('li[data-scene=bookmarks]').removeClass('active');
      },

      focusFirst: function() {
        this.$el.find('.videos-line li').first().trigger('mouseenter');
      },

      getFilmById: function(filmId) {
        for (var i=0; i<this.films.length; i++) {
          if (this.films[i].id == filmId) {
            return this.films[i];
          }
        }
      },

      back: function () {
        if (App.modules.videoController.back()) {
          return;
        } else {
          App.back();
        }
      }
    }
})();
