(function() {
    "use strict";
    var _inited = false;

    var App = window.App;
    var $ = window.$;
    var $$nav = window.$$nav;
    var Keys = window.Keys;

    App.scenes.search = {
  		toString: function() {
          return 'search';
      },

      init: function() {
        this.$el = $('.scene-search-content');
        _inited = true;
      },

  		show: function() {
        if (!_inited) {
            this.init();
        }

        this.$el.show();

        App.loader(false);

        $$nav.on('.wrap');

        // keys for this scene
        Keys.set('videoController');

  			// activate search icon
  			$('li[data-scene=search]').addClass('active');
      },

  		hide: function() {
        this.$el.hide();

  			$('li[data-scene=search]').removeClass('active');
      },

      reset: function() {
        console.log('RESET')
        App.dispatch(App.searchActions.setSearchText(''));
        $$nav.current($('#main-menu .menu-item_back'));
      },

      back: function () {
        if (!App.modules.interface.isVisible) {
          this.reset();
        }

        if (App.modules.videoController.back()) {
          return;
        } else {
          App.back();
        }
      }
    }
	})();
