/* global App, Keys */
/* global APP_CONFIG */
/* global $, $$nav */

(function() {
  "use strict";
  var _inited = false;

  App.scenes.settings = {
  		options: {
  			time: -new Date().getTimezoneOffset()/60,
  			server: App.getDefaultServer().name,
  			log: 'off',
        lang: 'en',
        buffering: APP_CONFIG.VIDEO_BUFFER_FOR_PLAY_SIZE_IN_SECOND,
  		},

  		toString: function() {
        return 'settings';
      },

      init: function() {
  			var self = this;

        this.$el = $('.scene-settings-content');

  			$('#elem-info').hide();

        this.$el.find('.settings-item').on({
  				'nav_focus': function(e) {},
  				'nav_blur': function(e) {},
  				'nav_key:enter': function(e) {
  					self.onSettingEnter(e);
  				}
  			});

        // Добавить функционал для стрелки налево чтобы было как у кнопки назад
        this.$el.find('.settings-sub-items').on({
  				'nav_key:left': function(e) {
  					e.stopPropagation()
            self.backFromInterface();
            return false;
  				},
          'nav_focus': function(e) {
  					self.onSubSettingFocus(e);
  				},
        })

        _inited = true;
      },

  		backFromInterface: function () {
  			var $current = $$nav.current();

  			// Выход из дочерней сцены настройки
  			if ($current.hasClass('settings-sub-item')) {

  				// Перебрасываем фокус в главное меню настроек
  				var setting = $current.parent().data('setting-content');
  				$$nav.current(this.$el.find("[data-setting='"+setting+"']"));

  				// Выйти в главное меню настроек
  				this.activateSetting(false);

  				return;
  			}

        // Выход из сцены настроек
  			if ($current.hasClass('settings-item')) {
  				App.back();
  				return;
  			}
  		},

  		// Восстановление настроек из localStore
  		restoreSettings: function () {
  			for (var setting in this.options) {
  				this.restoreSetting(setting);
  			}
  		},

      restoreSetting: function (setting) {
        if (!setting) {
          return;
        }

        var storagedSetting = localStorage.getItem("setting_" + setting);

        if (storagedSetting) {
          this.options[setting] = storagedSetting;
        }

        var settingItem = this.items[setting];

        if (!settingItem) {
          return;
        }

        settingItem.restore();
      },

  		show: function() {
        if (!_inited) {
            this.init();
        }

        this.$el.show();

        // keys for this scene
        Keys.set('settings');

  			// Прослушивать выбранную timeZone
  			this.$el.on('nav_key:enter', '.settings-sub-item', function (e) {
          App.scenes.settings.onSubSettingEnter(e);
        });

  			// activate settings icon
  			$('li[data-scene=settings]').addClass('active');

  			// default is time setting
  			// this.activateSetting('time');
  			$$nav.current(this.$el.find("[data-setting='time']"));
      },

  		hide: function() {
        this.$el.hide();

  			$('li[data-scene=settings]').removeClass('active');
      },

  		activateSetting: function (setting) {
        this.restoreSetting(setting);

        var $settingContent = $('[data-setting-content='+setting+']');

  			// Sub Setting menu
  			$('[data-setting-content]').hide();
  			if (setting) {
  				$settingContent.show();
  			}

  			// Active selected item
  			$('li[data-setting]').removeClass('active');
  			if (setting) {
  				$('li[data-setting='+setting+']').addClass('active');
  			}

  			// Вместо цвета переносить фокус, цвет вообще не нужен
  			if (setting) {
          console.log(this.options[setting]);

  				var $subSetting = $settingContent.find("[data-value='"+this.options[setting]+"']");
  				if ($subSetting.length) {
  					$$nav.current( $subSetting );
  				}
  				return $subSetting;
  			}
  		},

      getSettingValue: function(setting) {

      },

  		// Клик по внутреннему sub-item
  		onSubSettingEnter: function (e) {
  			var setting = $(e.currentTarget).parent().data('setting-content');

  			if (!setting) {
  				alert('Err: No Setting')
  				return;
  			}

  			// Storing
  			this.options[setting] = $(e.currentTarget).attr('data-value');
  			localStorage.setItem('setting_' + setting, this.options[setting]);

  			// Должно автоматически закрывать. Если выбрать настройку внутри после этого должно выкинуть в левое меню настроек
  			this.activateSetting(false);

  			// Перебрасываем фокус в главное меню настроек
        var $setting = this.$el.find("[data-setting='"+setting+"']");
  			$$nav.current($setting);

        $(e.currentTarget).click();

        var settingItem = this.items[setting];

        if (!settingItem) {
          return;
        }

        settingItem.subSettingEnter(e);
  		},

      //
      onSettingEnter: function(e) {
  			var setting = $(e.currentTarget).attr('data-setting');
  			var $setting = this.activateSetting( setting );

  			$$nav.current($setting);
      },

      returnFromView: function() {

      },

      onSubSettingFocus: function(e) {
        this.scrollToSetting($(e.target));
      },

      scrollToSetting: function($setting) {
        this.$el.stop().animate({
          scrollTop: $setting.height() * $setting.index()
        }, 500, 'swing', function() { });
      }
  }

  App.scenes.settings.items = {};

  var defaultItem = {
    subSettingEnter: function () {},
    restore: function () {},
    activate: function () {}
  };

  // Log
  App.scenes.settings.items.log = $.extend(defaultItem, {
    subSettingEnter: function () {
			this.activate();
		},

		restore: function () {
			this.activate();
		},

		activate: function () {
			$(function() {
				if (App.scenes.settings.options.log === 'on') {
					$('#log').show();
				} else {
					$('#log').hide();
				}
			})
		}
  });

  console.log('ITEMS', App.scenes.settings.items);

	// Восстановление настроек при старте приложения из localStore
	App.scenes.settings.restoreSettings();
})();
