var SB = window.SB;
var Player = window.Player;
var $ = window.$;

SB.readyForPlatform('browser', function () {

  $('#root').addClass('platform-browser');

    Player.extend({
        _init: function () {
            var self = this;
            var ww = 1280;
            var wh = 720;


            this.$video_container = $('<video id="smart_player" style="position: absolute; left: 0; top: 0;width: ' + ww + 'px; height: ' + wh + 'px;"></video>');
            var video = this.$video_container[0];
            $('body').append(this.$video_container);

            this.$video_container.on('loadedmetadata', function () {
                self.videoInfo.width = video.videoWidth;
                self.videoInfo.height = video.videoHeight;
                self.videoInfo.duration = video.duration;
                self.trigger('ready');
            });


            this.$video_container.on('loadstart',function (e) {
                self.trigger('bufferingBegin');
            }).on('playing',function () {
                    self.trigger('bufferingEnd');
                }).on('timeupdate',function () {
                    self.videoInfo.currentTime = video.currentTime;
                    self.trigger('update');
                }).on('ended', function () {
                    self.state = "stop";
                    self.trigger('complete');
                });


            this.$video_container.on('abort canplay canplaythrough canplaythrough durationchange emptied ended error loadeddata loadedmetadata loadstart mozaudioavailable pause play playing ratechange seeked seeking suspend volumechange waiting', function (e) {
                //console.log(e.type);
            });


            /*
             abort 	Sent when playback is aborted; for example, if the media is playing and is restarted from the beginning, this event is sent.
             canplay 	Sent when enough data is available that the media can be played, at least for a couple of frames.  This corresponds to the CAN_PLAY readyState.
             canplaythrough 	Sent when the ready state changes to CAN_PLAY_THROUGH, indicating that the entire media can be played without interruption, assuming the download rate remains at least at the current level. Note: Manually setting the currentTime will eventually fire a canplaythrough event in firefox. Other browsers might not fire this event.
             durationchange 	The metadata has loaded or changed, indicating a change in duration of the media.  This is sent, for example, when the media has loaded enough that the duration is known.
             emptied 	The media has become empty; for example, this event is sent if the media has already been loaded (or partially loaded), and the load() method is called to reload it.
             ended 	Sent when playback completes.
             error 	Sent when an error occurs.  The element's error attribute contains more information. See Error handling for details.
             loadeddata 	The first frame of the media has finished loading.
             loadedmetadata 	The media's metadata has finished loading; all attributes now contain as much useful information as they're going to.
             loadstart 	Sent when loading of the media begins.
             mozaudioavailable 	Sent when an audio buffer is provided to the audio layer for processing; the buffer contains raw audio samples that may or may not already have been played by the time you receive the event.
             pause 	Sent when playback is paused.
             play 	Sent when playback of the media starts after having been paused; that is, when playback is resumed after a prior pause event.
             playing 	Sent when the media begins to play (either for the first time, after having been paused, or after ending and then restarting).
             progress 	Sent periodically to inform interested parties of progress downloading the media. Information about the current amount of the media that has been downloaded is available in the media element's buffered attribute.
             ratechange 	Sent when the playback speed changes.
             seeked 	Sent when a seek operation completes.
             seeking 	Sent when a seek operation begins.
             suspend 	Sent when loading of the media is suspended; this may happen either because the download has completed or because it has been paused for any other reason.
             timeupdate 	The time indicated by the element's currentTime attribute has changed.
             volumechange 	Sent when the audio volume changes (both when the volume is set and when the muted attribute is changed).
             waiting 	Sent when the requested operation (such as playback) is delayed pending the completion of another operation (such as a seek).
             */
        },
        _play: function (options) {
            this.$video_container.show();
            this.$video_container.attr('src', options.url);
            this.$video_container[0].play();
        },
        _stop: function () {

            var video = this.$video_container[0];
            try {
              video.pause();
              video.removeAttribute('src'); // empty source
              video.load();
              this.$video_container.hide();
            } catch (e) {
              console.log(e);
            }
        },
        pause: function () {
            this.$video_container[0].pause();
            this.state = "pause";
        },
        resume: function () {
            this.$video_container[0].play();
            this.state = "play";
        },
        seek: function (time) {
            this.$video_container[0].currentTime = time;
        },
        audio: {
            //https://bugzilla.mozilla.org/show_bug.cgi?id=744896
            set: function (index) {

            },
            get: function () {
                return [];
            },
            cur: function () {
                return 0;
            }
        },
        subtitle: {
            set: function (index) {
                if (Player.$video_container[0].textTracks) {
                    var subtitles = _.filter(Player.$video_container[0].textTracks, function (i) {
                        return i.kind === 'subtitles';
                    });
                    if (subtitles.length) {
                        _.each(subtitles, function (self, i) {
                            if (self.mode === "showing") {
                                self.mode = "disabled";
                            }
                            else if (i == index) {
                                self.mode = "showing";
                            }
                        });
                        return true;
                    }
                }
                return false;
            },
            get: function () {
                if (Player.$video_container[0].textTracks) {
                    var subtitles = _.filter(Player.$video_container[0].textTracks, function (i) {
                        return i.kind === 'subtitles';
                    });
                    if (subtitles.length) {
                        return _.map(subtitles, function (self) {
                            return {index: subtitles.indexOf(self), language: self.language};
                        });
                    }
                }
                return false;
            },
            cur: function () {
                var cur = -1;
                if (Player.$video_container[0].textTracks) {
                    var subtitles = _.filter(Player.$video_container[0].textTracks, function (i) {
                        return i.kind === 'subtitles';
                    });
                    if (subtitles.length) {
                        _.each(subtitles, function (self, i) {
                            if (self.mode === "showing") {
                                cur = i;
                                return false;
                            }
                        });
                    }
                }
                return cur;
            },
            toggle: function () {
                var l = Player.subtitle.get().length;
                var cur = Player.subtitle.cur();
                if (l > 1) {
                    cur++;
                    if (cur >= l) {
                        cur = -1;
                    }
                    Player.subtitle.set(cur);
                }
            }
        }
    });
});

/**
 * Browser platform description
 */
SB.createPlatform('browser', {
    keys: {
        RIGHT: 39,
        LEFT: 37,
        DOWN: 40,
        UP: 38,
        RETURN: 27,//esc
        EXIT: 46,//delete
        TOOLS: 32,//space
        FF: 33,//page up
        RW: 34,//page down
        NEXT: 107,//num+
        PREV: 109,//num-
        ENTER: 13,
        RED: 65,//A
        GREEN: 66,//B
        YELLOW: 67,//C
        BLUE: 68,//D
        CH_UP: 221, // ]
        CH_DOWN: 219, // [
        N0: 48,
        N1: 49,
        N2: 50,
        N3: 51,
        N4: 52,
        N5: 53,
        N6: 54,
        N7: 55,
        N8: 56,
        N9: 57,
        PRECH: 45,//ins
        SMART: 36,//home
        PLAY: 97,//numpad 1
        STOP: 98,//numpad 2
        PAUSE: 99,//numpad 3
        SUBT: 76,//l,
        INFO: 73,//i
        REC: 82//r
    },

    detect: function () {
        // always true for browser platform
        return true;
    },

    getNativeDUID: function () {
        if (navigator.userAgent.indexOf('Chrome') != -1) {
            this.DUID = 'CHROMEISFINETOO';
        } else {
            this.DUID = 'FIREFOXISBEST';
        }
        return this.DUID;
    },

    volumeUp: function () {
    },

    volumeDown: function () {
    },

    getVolume: function () {
    }


});

(function ($) {
    "use strict";

    SB.readyForPlatform('browser', function () {
        _.extend($$voice, {
            _init: function () {
                this.helpbarVisible = true;
                $('body').append('<div id="voice_buble"></div><div id="help_voice_bubble"></div><div class="emul_voice_helpbar_wrap"><div id="emul_voice_helpbar"></div></div>');
                // клики по кнопкам эмулятора голоса
                $('#emul_voice_helpbar').on('click', '.emul_voice_trigger', function () {
                    $$voice.say(this.innerHTML);
                });
            },
            _nativeTurnOff: function () {
                $('#emul_voice_helpbar').empty();
            },
            _nativeFromServer: function (title, callback) {
                var text = prompt(title);
                callback(text || '');
            },
            _nativeCheckSupport: function () {
                return true;
            },
            _setVoiceHelp: function (voicehelp) {
                var $bar = $('#emul_voice_helpbar');
                $bar.empty();
                if (voicehelp.helpbarItemsList) {
                    $.each(voicehelp.helpbarItemsList, function (key, val) {
                        $('<div>', {
                            'attr': {
                                'class': "emul_voice_trigger main"
                            },
                            html: val.itemText,
                            appendTo: $bar
                        });
                    });
                }
                if (voicehelp.candidateList) {
                    $.each(voicehelp.candidateList, function (key, val) {
                        $('<div>', {
                            'attr': {
                                'class': "emul_voice_trigger"
                            },
                            html: val.candidate,
                            appendTo: $bar
                        });
                    });
                }
            }
        });
    });
})(jQuery);
