SB.readyForPlatform('lg', function () {
    var updateInterval;

    var isReady = false;

    Player.extend({
        updateDelay: 500,
        _init: function () {
            var self = this;
            $('body').append('<object type="video/mp4" data="" width="1280" height="720" id="pluginPlayer" style="z-index: 0; position: absolute; left: 0; top: 0;"></object>');
            this.plugin = $('#pluginPlayer')[0];
            this.$plugin = $(this.plugin);
            this.plugin.onPlayStateChange = function () {
                self.onEvent.apply(self, arguments);
            }
            this.plugin.onBuffering = function () {
                self.onBuffering.apply(self, arguments);
            }
        },
        onEvent: function(){
            if(this.plugin.playState=='5'){
                this.state='stop';
                this.trigger('complete');
            }
        },
        _update: function () {
            var info = this.plugin.mediaPlayInfo();

            if (info && !isReady) {
                //$('#log').append('<div>'+info.duration+'</div>');
                isReady = true;

                this.trigger('ready');
                this.videoInfo = {
                    duration: info.duration / 1000
                };
            }


            this.videoInfo.currentTime=info.currentPosition/1000;


            this.trigger('update');
        },
        onBuffering: function (isStarted) {
            this.trigger(isStarted ? 'bufferingBegin' : 'bufferingEnd');
        },
        _play: function (options) {
            clearInterval(updateInterval);
            updateInterval = setInterval(function () {

                Player._update();
            }, this.updateDelay);
            isReady = false;
            this.plugin.data = options.url;
            this.plugin.play(1);
        },
        pause: function(){
            this.plugin.play(0);
            this.state="pause";
        },
        resume: function(){
            this.plugin.play(1);
            this.state="play";
        },
        _stop: function () {
            this.plugin.stop();
            this.state="stop";
        },
        seek: function(time){
            this.plugin.seek(time*1000);
        }
    });
});
/**
 * LG platform
 */

SB.createPlatform('lg', {
    platformUserAgent: 'netcast',

    keys: {
        ENTER: 13,
        PAUSE: 19,
        LEFT: 37,
        UP: 38,
        RIGHT: 39,
        DOWN: 40,
        N0: 48,
        N1: 49,
        N2: 50,
        N3: 51,
        N4: 52,
        N5: 53,
        N6: 54,
        N7: 55,
        N8: 56,
        N9: 57,
        RED: 403,
        GREEN: 404,
        YELLOW: 405,
        BLUE: 406,
        RW: 412,
        STOP: 413,
        PLAY: 415,
        FF: 417,
        RETURN: 461,
        CH_UP: 33,
        CH_DOWN: 34
    },

    getNativeDUID: function () {
        return this.device.serialNumber;
    },

    getMac: function () {
        return this.device.net_macAddress.replace(/:/g, '');
    },

    getSDI: $.noop,

    setPlugins: function () {
        //this._listenGestureEvent();

        $('body').append('<object type="application/x-netcast-info" id="device" width="0" height="0"></object>');
        this.device = $('#device')[0];

        this.modelCode = this.device.version;
        this.productCode = this.device.platform;

        this.getDUID();


        //Log.show('default');
        setInterval(function () {
            //Log.show('default');
            var usedMemorySize;
            if (window.NetCastGetUsedMemorySize) {
                usedMemorySize = window.NetCastGetUsedMemorySize();
            }
            //Log.state(Math.floor(usedMemorySize * 100 / (1024 * 1024)) / 100, 'memory', 'profiler');
        }, 5000);


        if (Player && Player.setPlugin) {
            Player.setPlugin();
        }
    },

    sendReturn: function () {
        if (Player) {
            Player.stop(true);
        }
        window.NetCastBack();
    },

    exit: function () {
        Player && Player.stop(true);
        window.NetCastExit();
    },

    getUsedMemory: function () {
        return window.NetCastGetUsedMemorySize();
    },
    getChildlockPin: function () {
        return 1234;
    }
});
