SB.readyForPlatform('mag', function () {

    var updateInterval;
    var startUpdate = function () {
        var lastTime = 0;
        updateInterval = setInterval(function () {
            var position = stb.GetPosTime();
            //if (position != lastTime) {
            Player.videoInfo.currentTime = position;
            Player.trigger('update');
            SB.utils.log.state(position, 'position', 'player');
            //}
            //lastTime = position;
        }, 500);
    }
    var stopUpdate = function () {
        clearInterval(updateInterval);
    }

    window.stbEvent =
    {

        onEvent: function (data) {

            data += '';
            if (data == '1') {
                Player.trigger('complete');
            } else if (data == '2') {
                Player.videoInfo.duration = stb.GetMediaLen() + 1;
                Player.videoInfo.currentTime = 0;
                Player.trigger('ready');
            }
            else if (data == '4') {
                Player.trigger('bufferingEnd');
            }
            else if (data == '7') {
                var vi = eval(stb.GetVideoInfo());
                Player.videoInfo.width = vi.pictureWidth;
                Player.videoInfo.height = vi.pictureHeight;
            }
        },
        event: 0
    };


    var stb = window.gSTB;
    Player.extend({
        _init: function () {
            stb.InitPlayer();
            stb.SetViewport(1280, 720, 0, 0);
            stb.SetTopWin(0);
        },
        _play: function (options) {
            stb.Play(options.url);
            startUpdate();
            Player.trigger('bufferingBegin');
        },
        _stop: function () {
            stb.Stop();
            stopUpdate();
        },
        pause: function () {
            stb.Pause();
            this.state = "pause";
            stopUpdate();
        },
        resume: function () {
            stb.Continue();
            this.state = "play";
            startUpdate();
        },
        seek: function (time) {
            stb.SetPosTime(time)
        },
        audio: {
            set: function (index) {
                stb.SetAudioPID(index);
            },
            get: function () {
                return stb.GetAudioPIDs();
            },
            cur: function () {
                return stb.GetAudioPID();
            }
        },
        subtitle: {
            set: function (index) {
                stb.SetSubtitlePID(index);
            },
            get: function () {
                var subtitles = [];
                _.each(stb.GetSubtitlePIDs(), function (self) {
                    subtitles.push({index: self.pid, language: self.lang[1]});
                });
                return subtitles;
            },
            cur: function () {
                return stb.GetSubtitlePID();
            }
        }
    });
});

(function () {

    var stb;
    /**
     * Mag set top box platform description
     */
    SB.createPlatform('mag', {
        keys: {
            RIGHT: 39,
            LEFT: 37,
            DOWN: 40,
            UP: 38,
            RETURN: 8,
            EXIT: 27,
            TOOLS: 122,
            FF: 70,
            RW: 66,
            NEXT: 34,
            PREV: 33,
            ENTER: 13,
            RED: 112,
            GREEN: 113,
            YELLOW: 114,
            BLUE: 115,
            CH_UP: 9,
            CH_DOWN: 9,
            N0: 48,
            N1: 49,
            N2: 50,
            N3: 51,
            N4: 52,
            N5: 53,
            N6: 54,
            N7: 55,
            N8: 56,
            N9: 57,
            PRECH: 116,
            POWER: 85,
            //SMART: 36,
            PLAY: 82,
            STOP: 83,
            //PAUSE: 99,
            //SUBT: 76,
            INFO: 89
            //REC: 82
        },

        onDetect: function () {

            var isStandBy = false;

            stb = window.gSTB;

            window.moveTo(0, 0);
            window.resizeTo(1280, 720);

            SB(function () {
              var $body = $(document.body);
              $body.on('nav_key:power', function () {
                var eventName = 'standby_';
                isStandBy = !isStandBy;

                eventName += isStandBy ? 'set' : 'unset';
                stb.StandBy(isStandBy);

                // TODO: trigger events on SB
                $$log('trigger standby event ' + eventName, 'standby');
                $body.trigger(eventName);
              });
            });


            window.localStorage = {
                setItem: function (name, data) {

                },
                clear: function () {

                },
                getItem: function () {

                },
                removeItem: function () {

                }
            }
        },

        detect: function () {
            return !!window.gSTB;
        },

        exit: function () {
            $$log('try to location change');
            Player.stop(true);
            gSTB.DeinitPlayer();
            window.location = 'file:///home/web/services.html';
        },

        sendReturn: function () {
            this.exit();
        },

        getNativeDUID: function () {

        },

        volumeUp: function () {
        },

        volumeDown: function () {
        },

        getVolume: function () {
        }
    });

}());
